#!/bin/bash

echo "Checking consul for app configs"
SVC_KEY_PKCS12=$(curl $CONSUL_SERVER/v1/kv/$CONSUL_PATH/SVC_KEY_PKCS12 -H "X-Consul-Token: $CONSUL_TOKEN" | jq -r '.[0].Value' | base64 --decode)
SVC_KEY_PKCS12_PWD=$(curl $CONSUL_SERVER/v1/kv/$CONSUL_PATH/SVC_KEY_PKCS12_PWD -H "X-Consul-Token: $CONSUL_TOKEN" | jq -r '.[0].Value' | base64 --decode)
SVC_KEYSTORE_PWD=$(curl $CONSUL_SERVER/v1/kv/$CONSUL_PATH/SVC_KEYSTORE_PWD -H "X-Consul-Token: $CONSUL_TOKEN" | jq -r '.[0].Value' | base64 --decode)

if [[ -n $SVC_KEY_PKCS12 && -n $SVC_KEY_PKCS12_PWD ]]; then
    defaultKeystorePwd=${SVC_KEYSTORE_PWD:-changeit}

    echo $SVC_KEY_PKCS12 | base64 -d > vamf_temp_keystore.p12 && \
    keytool -v -importkeystore -srckeystore vamf_temp_keystore.p12 -srcstoretype PKCS12 -srcstorepass ${SVC_KEY_PKCS12_PWD} -destkeystore var.mobilehealth.DOMAIN.EX.jks -deststoretype JKS -alias 1 -destalias var -destkeypass $defaultKeystorePwd -deststorepass $defaultKeystorePwd
else
	echo "SVC_KEY_PKCS12 and/or SVC_KEY_PKCS12_PWD environment variables were not set, so not importing keys."
fi

envconsul -consul $CONSUL_SERVER -token $CONSUL_TOKEN -prefix $CONSUL_PATH $CATALINA_HOME/bin/catalina.sh run
T